/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("scripts/Cam/CamExportV2/CamExporterV2.js");

/**
 * Outputs HP-GL.
 */
function Hpgl(cadDocumentInterface, camDocumentInterface) {
    // call constructor of base class 'CamExporterV2':
    CamExporterV2.call(this, cadDocumentInterface, camDocumentInterface);

    if (isNull(cadDocumentInterface)) {
        // constructor used as prototype:
        return;
    }

    this.outputOffsetPath = true;

    this.decimals = 4;
    this.unit = RS.Millimeter;
    this.scale = 40.0;
    this.separator = ";";
    this.lineEnding = "";
    this.fileExtensions = [ "plt" ];

    this.registerVariable("xStartPosition",      "X1",                   true, "", "DEFAULT", "DEFAULT");
    this.registerVariable("yStartPosition",      "Y1",                   true, "", "DEFAULT", "DEFAULT");
    this.registerVariable("xPosition",           "X",                    true, "", "DEFAULT", "DEFAULT");
    this.registerVariable("yPosition",           "Y",                    true, "", "DEFAULT", "DEFAULT");
    this.registerVariable("iArcCenterAbs",       "IA",                   true, "", "DEFAULT", "DEFAULT");
    this.registerVariable("jArcCenterAbs",       "JA",                   true, "", "DEFAULT", "DEFAULT");
    this.registerVariable("arcSweep",            "SWEEP",                true, "", "DEFAULT", { factor: 360/Math.PI/2 });

    this.header = "\u001B.(;\u001B.I81;;17:\u001B.N;19:IN;SC;PU;VS;VS36;SP1;PU;";
    this.footer = "PA0,0;SP;EC;PG1;EC1;OE;";

    this.linearMove = "PA[X],[Y]" + this.separator;
    this.firstLinearMove = this.linearMove;

    this.arcCWMove = "AA[IA],[JA],[SWEEP]" + this.separator;
    this.firstArcCWMove = this.arcCWMove;

    this.arcCCWMove = "AA[IA],[JA],[SWEEP]" + this.separator;
    this.firstArcCCWMove = this.arcCCWMove;

    this.zPassHeader = "PA[X1],[Y1]" + this.separator + "PD" + this.separator;
    this.zPassFirstHeader = this.zPassHeader;

    this.zPassFooter = "PU" + this.separator;
    this.zPassLastFooter = this.zPassFooter;
}

Hpgl.prototype = new CamExporterV2();
Hpgl.displayName = "HP-GL";

