/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("GCodeBase.js");

/**
 * Base configuration for UCCNC controllers.
 * Defines footer and compensation off move.
 */
function UcCnc(documentInterface, camDocumentInterface) {
    GCodeBase.call(this, documentInterface, camDocumentInterface);

    this.outputOffsetPath = true;

//    this.toolpathHeader = ["toolpathHeader"];
//    this.toolpathFooter = ["toolpathFooter"];
//    this.contourHeader = ["contourHeader"];
//    this.contourFooter = ["contourFooter"];
//    this.singleZPassHeader = ["singleZPassHeader"];
//    this.singleZPassFooter = ["singleZPassFooter"];
//    this.multiZPassHeader = ["multiZPassHeader"];
//    this.multiZPassFooter = ["multiZPassFooter"];
//    this.zPassFirstHeader = ["zPassFirstHeader"];
//    this.zPassFirstFooter = ["zPassFirstFooter"];
//    this.zPassHeader = ["zPassHeader"];
//    this.zPassFooter = ["zPassFooter"];

    // G43: Apply offsets for this tool
    // H..: Position to use from tool table
    this.toolHeader = [
        "[N] [T] M06",
        "[N] G00 G43 [ZS!] H[T#]",
        "[N] [S] M03",
        "[N] G94"
    ];

    // M09: All coolant off
    // M30: Program end and rewind
    // %: Comment, not executed (might be needed)
    this.footer = [
        "[N] M05",
        "[N] M30",
        "%"
    ];

    // UCCNC has G40 on separate line,
    // followed by a G1 with the position to move to:
//    this.linearMoveCompensationOff = [
//        "[N] G40",
//        "[N] G1 [X] [Y]"
//    ];
}

UcCnc.prototype = new GCodeBase();
UcCnc.displayName = "";
