/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("Emc2.js");

/**
 * Configuration for EMC2 controllers.
 * Output in Inches.
 */
function Emc2IN(cadDocumentInterface, camDocumentInterface) {
    Emc2.call(this, cadDocumentInterface, camDocumentInterface);

    this.unit = RS.Inch;

    // G20: Inch
    // G64 P#: Tolerance. Fine tune system for best compromise between speed and accuracy
    this.header = [
        "%",
        "(FILE: [FILENAME])",
        "G20",
        "G64 P0.025"
    ];
}

// Configuration is derived from GCodeBase:
Emc2IN.prototype = new Emc2();

// Display name shown in user interface:
Emc2IN.displayName = "EMC2 [in]";
