/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */

include("GCodeBase.js");

/**
 * Base configuration for G-Code based Laser controllers.
 */
function LaserBase(cadDocumentInterface, camDocumentInterface, noZMovements) {
    GCodeBase.call(this, cadDocumentInterface, camDocumentInterface);

    if (isNull(noZMovements)) {
        noZMovements = true;
    }

    this.noZMovements = noZMovements;

    if (this.noZMovements) {
        this.rapidMoveZ = [];

        this.firstLinearMoveZ = [];
        this.linearMoveZ = [];

        this.firstPointMoveZ = [];
        this.pointMoveZ = [];
    }

    this.toolHeader = [];

    // maybe better:
    this.registerVariable("spindleSpeed",        "S",                    false,  "S", 0);
}

LaserBase.prototype = new GCodeBase();

LaserBase.displayName = "";
LaserBase.description = "";

LaserBase.prototype.getToolTypeTitle = function(toolType) {
    if (isString(toolType)) {
        toolType = parseInt(toolType);
    }

    switch (toolType) {
    case Cam.ToolType.Mill:
        return qsTr("Laser");
    default:
        return undefined;
    }
};

LaserBase.prototype.postInitDialog = function(obj, dialog, di, block) {
    var w;

    if (dialog.objectName==="CamProfileToolpathDialog") {
        w = dialog.findChild("CamSpindleSpeed_Label");
        w.visible = true;
        w.setText(qsTr("Power:"));
        w = dialog.findChild("CamSpindleSpeed");
        w.visible = true;
        w = dialog.findChild("CamSpindleSpeed_Unit");
        w.setText("");
        w.visible = true;

        if (this.noZMovements) {
            // only display "passes" of cutting depths group:
            w = dialog.findChild("CuttingDepths_Group");
            w.visible = false;
            var layout = dialog.layout();
            var gb = new QGroupBox(qsTr("Passes"));
            layout.addWidget(gb, 1, 0)

            var layout2 = new QHBoxLayout();
            w = dialog.findChild("CamZPasses_Label");
            layout2.addWidget(w, 0, 0);
            w = dialog.findChild("CamZPasses");
            layout2.addWidget(w, 0, 0);
            layout2.addStretch();
            gb.setLayout(layout2);
        }
    }

    if (dialog.objectName==="CamToolDialog") {
        // change "Spindle Speed" to "Power":
        w = dialog.findChild("CamSpindleSpeed_Label");
        w.setText(qsTr("Power:"));

        w = dialog.findChild("CamSpindleSpeed_Unit");
        w.setText("");

        if (this.noZMovements) {
            w = dialog.findChild("CamPlungeRate");
            w.setText("0");
            w.visible = false;
            w = dialog.findChild("CamPlungeRate_Label");
            w.visible = false;
        }
    }
};

LaserBase.prototype.initEntity = function(entity) {
    GCodeBase.prototype.initEntity.call(this, entity);

    // overwrite spindle speed per entity (laser engraving of images):
    var spindleSpeed = this.getEntityOptionFloat(this.currentEntity, "CamSpindleSpeed", undefined);
    if (!isNull(spindleSpeed)) {
        this.spindleSpeed = spindleSpeed;
    }
};
