/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("Mach3.js");

/**
 * Configuration for Mach3 controllers.
 * Output in Millimeters.
 */
function Mach3MM(documentInterface, camDocumentInterface) {
    Mach3.call(this, documentInterface, camDocumentInterface);

    this.decimals = 4;
    this.unit = RS.Millimeter;

    // G21: Millimeter unit
    // G17: XY Plane select
    // G90: Absolute distance mode
    // G40: Cancel cutter radius compensation
    // G49: Cancel tool length offset
    // G80: Cancel motion mode
    // G71: Millimeter unit
    // G91.1: Incremental distance mode for I/J
    this.header = [
        "[N] G21 G17 G90 G40 G49 G80",
        "[N] G71 G91.1"
    ];
}

Mach3MM.prototype = new Mach3();
Mach3MM.displayName = "Mach3 (G41/G42) [mm]";
