/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("AdtHc4500.js");

/**
 * Configuration for AdtHc4500 controllers.
 * Output in Millimeters.
 */
function AdtHc4500RelMM(documentInterface, camDocumentInterface) {
    AdtHc4500.call(this, documentInterface, camDocumentInterface);

    this.decimals = 3;
    this.unit = RS.Millimeter;

    this.header = [
        "G90 X0. Y0.",
        "G21",
        "G91",
    ];

    this.footer = [
        "G0 X0 Y0",
    ];

    this.rapidMove = "G0[XR][YR]";
    this.firstRapidMove = this.rapidMove;
    this.linearMove = "G1[XR][YR][F]";
    this.firstLinearMove = this.linearMove;

    this.arcCWMove = "G2[XR][YR][I][J][F]";
    this.firstArcCWMove = this.arcCWMove;

    this.arcCCWMove = "G3[XR][YR][I][J][F]";
    this.firstArcCCWMove = this.arcCCWMove;
}

AdtHc4500RelMM.prototype = new AdtHc4500();
AdtHc4500RelMM.displayName = "ADT HC4500 Relative (Offset) [mm]";
