/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("GCodeIN.js");
include("scripts/date.js");

/**
 * This configuration outputs the offset path for
 * the tool radius compensation 
 * Output in Inches.
 */
function LxcncIn(documentInterface, camDocumentInterface) {
    GCodeIN.call(this, documentInterface, camDocumentInterface);

    this.fileExtensions = [ "ngc" ];

    // register variable for date and time:
    this.dateTime = undefined;
    this.registerVariable("dateTime", "DATE_TIME", true, "",  0);

    this.header = [
        "%",
        "( CREATED WITH QCAD-CAM  )",
        "(     FILE PATH: [FILEPATH])",
        "(     FILE NAME: [FILENAME])",
        "(     DATE/TIME: [DATE_TIME])",
        "(    CUTTER NUM: [T])",
        "(    CUTTER DIA: [TD])",
        "(    CUTTER NOTES: [PROGRAM_NAME])",
        "G20 G17 G40 G49 G54 G80 G90 G94",
        "G64 P0.001"  // tighten tolerance
    ];

    this.footer = [
	"M02",
	"%"
    ];

    this.toolHeader = [
        "M6 [T]"
    ];

    this.rapidMove =                 "G0 [X] [Y]";
    this.rapidMoveZ =                "G0 [Z]";

    this.firstLinearMove =           "G1 [X] [Y] [F]";
    this.firstLinearMoveZ =          "G1 [Z] [F]";
    this.linearMove =                "[X] [Y] [F]";
    this.linearMoveZ =               "[Z] [F]";

    this.firstArcCWMove =            "G2 [X] [Y] [I] [J] [F]";
    this.arcCWMove =                 "G2 [X] [Y] [I] [J] [F]";

    this.firstArcCCWMove =           "G3 [X] [Y] [I] [J] [F]";
    this.arcCCWMove =                "G3 [X] [Y] [I] [J] [F]";
    this.linearMoveCompensationLeft = [
        "[F!]",
        "G41 [X] [Y]"
    ];

    this.linearMoveCompensationRight = [
        "[F!]",
        "G42 [X] [Y]"
    ];
    this.linearMoveCompensationOff = [
        "G40",
        "G1 [X] [Y]"
    ];

}

LxcncIn.prototype = new GCodeIN();
LxcncIn.displayName = "Lxcnc [in]";

LxcncIn.prototype.writeFile = function(fileName) {
    // init date / time variable:
    var today = new Date();
    this.dateTime = formatDate(today, "dd/MMM/yyyy hh:mm:ss");
    
    GCodeIN.prototype.writeFile.call(this, fileName);
};

