/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("scripts/Cam/CamExportV2/CamExporterV2.js");

/**
 * DXF post processor.
 */
function Dxf(cadDocumentInterface, camDocumentInterface) {
    // call constructor of base class 'CamExporterV2':
    CamExporterV2.call(this, cadDocumentInterface, camDocumentInterface);

    if (isNull(cadDocumentInterface)) {
        // constructor used as prototype:
        return;
    }

    this.outputOffsetPath = true;
    this.fileExtensions = [ "dxf" ];

    this.entities = [];
}

Dxf.prototype = new CamExporterV2();
Dxf.displayName = "DXF";

Dxf.prototype.writeFile = function(fileName) {
    qDebug("writing DXF file...");

    this.entities = [];

    CamExporterV2.prototype.writeFile.call(this, fileName);

    var flat = this.getGlobalOptionBool("Cam2D", "1");

    var doc = new RDocument(new RMemoryStorage(), createSpatialIndex());
    var di = new RDocumentInterface(doc);

    var op = new RAddObjectsOperation();
    for (var i=0; i<this.entities.length; i++) {
        var e = this.entities[i];
        e.setDocument(doc);
        //e.setLayerId(doc.getLayer0Id());
        //e.setLinetypeId(doc.getLinetypeByLayerId());
        //e.setLineweight()
        if (flat) {
            e.to2D();
        }
        op.addObject(e, true, true);
    }
    di.applyOperation(op);

    var filter = this.getGlobalOption("CamDxfOutputFilter", "DXF");
    if (!di.exportFile(fileName, filter)) {
        var text = qsTr("File %1 has not been exported.").arg(fileName);
        var appWin = EAction.getMainWindow();
        appWin.handleUserWarning(text, true);
        appWin.setProgressText();
    }
    else {
        if (this.getGlobalOptionBool("CamOpen", "1")===true) {
            // open output file:
            openFiles([fileName], false, true);
        }
    }

//    var toolpathBlocks = Cam.getToolpathBlocks(doc, true);

//    for (var i=0; i<toolpathBlocks.length; i++) {
//        var ids = doc.queryBlockEntities();
//    }
};

Dxf.prototype.exportShape = function(shape) {
    if (isSplineShape(shape)) {
        if (this.getGlobalOptionBool("CamInterpolateSplines", "1")===false) {
            this.exportSpline(shape);
            return;
        }
    }
    else if (isEllipseShape(shape)) {
        if (this.getGlobalOptionBool("CamInterpolateEllipses", "1")===false) {
            this.exportEllipse(shape);
            return;
        }
    }

    CamExporterV2.prototype.exportShape.call(this, shape);
};

Dxf.prototype.writeEntity = function() {
    if (this.currentEntity.hasCustomProperty("QCAD", "CamRapidMove") ||
        this.currentEntity.hasCustomProperty("QCAD", "CamZMove")) {
        return;
    }

    this.entities.push(this.currentEntity.clone());
};

Dxf.prototype.initConfigDialog = function(dialog) {
    var group = dialog.findChild("GroupCustom");
    group.title = qsTr("DXF Output");

    // get QVBoxLayout:
    var vBoxLayout = group.layout();

    // add checkboxes:
    var cbInterpolateSplines = new QCheckBox(qsTr("Interpolate Splines"));
    cbInterpolateSplines.checked = true;
    cbInterpolateSplines.objectName = "CamInterpolateSplines";
    vBoxLayout.addWidget(cbInterpolateSplines, 0,0);

    var cbInterpolateEllipses = new QCheckBox(qsTr("Interpolate Ellipses"));
    cbInterpolateEllipses.checked = true;
    cbInterpolateEllipses.objectName = "CamInterpolateEllipses";
    vBoxLayout.addWidget(cbInterpolateEllipses, 0,0);

    cbInterpolateEllipses = new QCheckBox(qsTr("Flatten to 2D (Z=0)"));
    cbInterpolateEllipses.checked = true;
    cbInterpolateEllipses.objectName = "Cam2D";
    vBoxLayout.addWidget(cbInterpolateEllipses, 0,0);

    var cbOpen = new QCheckBox(qsTr("Open after export"));
    cbOpen.checked = true;
    cbOpen.objectName = "CamOpen";
    vBoxLayout.addWidget(cbOpen, 0,0);

    // add label and combo box to choose format:
    var hBoxLayout = new QHBoxLayout(null);
    vBoxLayout.addLayout(hBoxLayout, 0);

    var lFormat = new QLabel(qsTr("Format:"));
    hBoxLayout.addWidget(lFormat, 0,0);

    var cbFormat = new QComboBox();
    cbFormat.objectName = "CamDxfOutputFilter";
    var filterStrings = RFileExporterRegistry.getFilterStrings();
    filterStrings = translateFilterStrings(filterStrings);
    for (var i=0; i<filterStrings.length; i++) {
        if (filterStrings[i].contains("DXF")) {
            cbFormat.addItem(filterStrings[i]);
        }
    }
    hBoxLayout.addWidget(cbFormat, 0,0);
};
