/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("GCodeBase.js");

function Tnc430MM(cadDocumentInterface, camDocumentInterface) {
    GCodeBase.call(this, cadDocumentInterface, camDocumentInterface);

    this.decimals = 3;
    this.options = {
        sign: true,
        decimalSeparator: ",",
        trailingZeroes: true
    };

    this.unit = RS.Millimeter;
    this.fileExtensions = [ "h" ];
    this.splitFullCircles = true;
    this.lineNumber = 0;
    this.lineNumberIncrement = 1;
    this.outputOffsetPath = true;

    /**
     * Header includes block form (extends + 10%) for simulation.
     */
    this.header = [
        "[N#] BEGIN PGM [PROGRAM_NAME] MM",
        "[N#] BLK FORM 0.1 Z X[X_MIN] Y[Y_MIN] Z[Z_MIN]",
        "[N#] BLK FORM 0.2 X[X_MAX] Y[Y_MAX] Z[Z_MAX]",
        "[N#] L [ZS!] R0 FMAX",
    ];
    this.footer = [
        "[N#] L [ZS!] R0 FMAX M5 M30",
        "[N#] END PGM [PROGRAM_NAME] MM"
    ];

    this.toolHeader = [
        "[N#] TOOL CALL [T#] Z [S]",
        "[N#] L M3"
    ];

    this.rapidMove = [
        "[N#] L [X] [Y] FMAX"
    ];
    this.rapidMoveZ = [
        "[N#] L [Z] FMAX"
    ];

    this.linearMove = [
        "[N#] L [X] [Y] [F]"
    ];
    this.linearMoveZ = [
        "[N#] L [Z] [F]"
    ];

    this.arcCWMove = [
        "[N#] CC X[IA#] Y[JA#]",
        "[N#] C [X] [Y] DR- [F]"
    ];

    this.arcCCWMove = [
        "[N#] CC X[IA#] Y[JA#]",
        "[N#] C [X] [Y] DR+ [F]"
    ];

    this.firstLinearMove = this.linearMove;
    this.firstLinearMoveZ = this.linearMoveZ;
    this.firstArcCWMove = this.arcCWMove;
    this.firstArcCCWMove = this.arcCCWMove;

    this.linearMoveCompensationLeft = [];
    this.linearMoveCompensationRight = [];
    this.linearMoveCompensationOff = [];

    this.ignoredOutput = [ "[0-9]+ L" ];
}

Tnc430MM.prototype = new GCodeBase();
Tnc430MM.displayName = "Heidenhain TNC430 [mm]";

Tnc430MM.prototype.initExtents = function() {
    GCodeBase.prototype.initExtents.call(this);

    // add 10% to X/Y extents:
    var xDim = this.xMax-this.xMin;
    var yDim = this.yMax-this.yMin;
    var zDim = this.zMax-this.zMin;

    this.xMin -= xDim*0.1;
    this.yMin -= yDim*0.1;
    this.xMax += xDim*0.1;
    this.yMax += yDim*0.1;

    // check ratio:
    xDim = this.xMax-this.xMin;
    yDim = this.yMax-this.yMin;
    zDim = this.zMax-this.zMin;

    var maxDim = Math.max(xDim, yDim, zDim);
    if (xDim < maxDim/64) {
        this.xMin = this.xMax - maxDim/64;
    }
    if (yDim < maxDim/64) {
        this.yMin = this.yMax - maxDim/64;
    }
    if (zDim < maxDim/64) {
        this.zMin = this.zMax - maxDim/64;
    }

};
